<?php

namespace Tests\Feature;

use Illuminate\Foundation\Testing\RefreshDatabase;
use Tests\TestCase;

class GameCallbackTest extends TestCase
{
    use RefreshDatabase;

    public function test_callback_processes_transaction_idempotently(): void
    {
        config(['games.providers.agula-hoccy.secret' => 'test-secret']);
        $payload = json_encode([
            'event' => 'transaction',
            'tx_id' => 'tx-123',
            'type' => 'credit',
            'amount' => 10,
            'currency' => 'USD',
            'player_id' => 1,
            'session_id' => 'sess-1',
        ]);
        $sig = hash_hmac('sha256', $payload, 'test-secret');

        $this->postJson('/api/games/agula-hoccy/callback', json_decode($payload, true), [
            'X-Signature' => $sig,
        ])->assertStatus(200);

        $this->postJson('/api/games/agula-hoccy/callback', json_decode($payload, true), [
            'X-Signature' => $sig,
        ])->assertStatus(200);
    }
}

