<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title><?php echo e($title ?? 'Casino'); ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>
<nav class="navbar navbar-expand-lg navbar-dark bg-dark">
  <div class="container">
    <a class="navbar-brand" href="<?php echo e(url('/')); ?>">Casino</a>
    <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav" aria-controls="navbarNav" aria-expanded="false" aria-label="Toggle navigation">
      <span class="navbar-toggler-icon"></span>
    </button>
    <div class="collapse navbar-collapse" id="navbarNav">
      <ul class="navbar-nav me-auto mb-2 mb-lg-0">
        <li class="nav-item"><a class="nav-link" href="<?php echo e(url('/games')); ?>">Games</a></li>
        <?php if(auth()->guard()->check()): ?>
        <li class="nav-item"><a class="nav-link" href="<?php echo e(url('/user')); ?>">User</a></li>
        <li class="nav-item"><a class="nav-link" href="<?php echo e(url('/admin')); ?>">Admin</a></li>
        <?php endif; ?>
      </ul>
      <ul class="navbar-nav">
        <?php if(auth()->guard()->check()): ?>
          <li class="nav-item"><span class="navbar-text me-2"><?php echo e(auth()->user()->name); ?></span></li>
          <li class="nav-item">
            <form method="post" action="<?php echo e(url('/logout')); ?>" class="d-inline">
              <?php echo csrf_field(); ?>
              <button class="btn btn-outline-light btn-sm">Logout</button>
            </form>
          </li>
        <?php else: ?>
          <li class="nav-item"><a class="nav-link" href="<?php echo e(url('/login')); ?>">Login</a></li>
          <li class="nav-item"><a class="nav-link" href="<?php echo e(url('/register')); ?>">Register</a></li>
        <?php endif; ?>
      </ul>
    </div>
  </div>
  </nav>
<main class="py-4">
  <div class="container">
    <?php echo $__env->yieldContent('content'); ?>
  </div>
</main>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
<?php /**PATH /home/devsheikhit/public_html/vyx.dev.sheikhit.net/resources/views/layouts/app.blade.php ENDPATH**/ ?>