<?php $__env->startSection('content'); ?>
<h3 class="mb-3">My Wallet</h3>
<div class="row g-3">
  <div class="col-md-4">
    <div class="card"><div class="card-body">
      <h5 class="card-title">Balance</h5>
      <div id="balanceBox">Loading...</div>
    </div></div>
  </div>
  <div class="col-md-4">
    <div class="card"><div class="card-body">
      <h5 class="card-title">Deposit</h5>
      <form id="depositForm" method="post" action="<?php echo e(url('/wallet/deposit')); ?>">
        <input type="hidden" name="_token" value="<?php echo e(csrf_token()); ?>">
        <div class="mb-2">
          <label class="form-label">Amount</label>
          <input type="number" step="0.01" min="0.01" name="amount" class="form-control" required>
        </div>
        <div class="mb-2">
          <label class="form-label">Currency</label>
          <select name="currency" class="form-select">
            <option value="<?php echo e(env('GAMES_DEFAULT_CURRENCY', 'BD_BDT')); ?>"><?php echo e(env('GAMES_DEFAULT_CURRENCY', 'BD_BDT')); ?></option>
          </select>
        </div>
        <button class="btn btn-primary w-100">Deposit</button>
      </form>
    </div></div>
  </div>
  <div class="col-md-4">
    <div class="card"><div class="card-body">
      <h5 class="card-title">Withdraw</h5>
      <form id="withdrawForm" method="post" action="<?php echo e(url('/wallet/withdraw')); ?>">
        <input type="hidden" name="_token" value="<?php echo e(csrf_token()); ?>">
        <div class="mb-2">
          <label class="form-label">Amount</label>
          <input type="number" step="0.01" min="0.01" name="amount" class="form-control" required>
        </div>
        <div class="mb-2">
          <label class="form-label">Currency</label>
          <select name="currency" class="form-select">
            <option value="<?php echo e(env('GAMES_DEFAULT_CURRENCY', 'BD_BDT')); ?>"><?php echo e(env('GAMES_DEFAULT_CURRENCY', 'BD_BDT')); ?></option>
          </select>
        </div>
        <button class="btn btn-outline-danger w-100">Withdraw</button>
      </form>
    </div></div>
  </div>
</div>

<div class="card mt-3"><div class="card-body">
  <h5 class="card-title">My Bet History</h5>
  <div class="table-responsive">
    <table class="table table-sm">
      <thead><tr><th>ID</th><th>Provider</th><th>Type</th><th>Amount</th><th>Currency</th><th>Tx ID</th><th>Processed</th></tr></thead>
      <tbody id="txBody"><tr><td colspan="7">Loading...</td></tr></tbody>
    </table>
  </div>
</div></div>

<script>
  async function fetchBalance() {
    try {
      const r = await fetch('/wallet/balance?currency=<?php echo e(env('GAMES_DEFAULT_CURRENCY', 'BD_BDT')); ?>', { headers: { 'Accept': 'application/json' }});
      if (!r.ok) { document.getElementById('balanceBox').textContent = '0.00 <?php echo e(env('GAMES_DEFAULT_CURRENCY', 'BD_BDT')); ?>'; return; }
      const j = await r.json();
      let amt = 0;
      if (typeof j.balance === 'number') { amt = j.balance; }
      else if (typeof j.balance === 'string') { const f = parseFloat(j.balance); amt = isNaN(f) ? 0 : f; }
      const cur = (typeof j.currency === 'string' && j.currency) ? j.currency : '<?php echo e(env('GAMES_DEFAULT_CURRENCY', 'BD_BDT')); ?>';
      document.getElementById('balanceBox').textContent = `${amt.toFixed(2)} ${cur}`;
    } catch (_) {
      document.getElementById('balanceBox').textContent = '0.00 <?php echo e(env('GAMES_DEFAULT_CURRENCY', 'BD_BDT')); ?>';
    }
  }
  async function submitForm(id, url) {
    const form = document.getElementById(id);
    const fd = new FormData(form);
    const token = form.querySelector('input[name=\"_token\"]')?.value || '';
    const headers = { 'Accept': 'application/json' };
    if (token) headers['X-CSRF-TOKEN'] = token;
    const r = await fetch(url, { method: 'POST', body: fd, headers });
    if (r.ok) { await fetchBalance(); alert('Success'); } else { alert('Failed'); }
  }
  document.getElementById('depositForm').addEventListener('submit', (e) => {
    e.preventDefault(); submitForm('depositForm', '/wallet/deposit');
  });
  document.getElementById('withdrawForm').addEventListener('submit', (e) => {
    e.preventDefault(); submitForm('withdrawForm', '/wallet/withdraw');
  });
  async function fetchMyTransactions() {
    const r = await fetch('/admin/transactions?player_id=<?php echo e(auth()->user()->player->id ?? 0); ?>', { headers: { 'Accept': 'text/html' }});
    const html = await r.text();
    const tmp = document.createElement('div'); tmp.innerHTML = html;
    const rows = tmp.querySelectorAll('tbody tr');
    const txRows = Array.from(rows).slice(rows.length - 200);
    const body = document.getElementById('txBody');
    body.innerHTML = '';
    txRows.forEach((tr) => {
      const tds = tr.querySelectorAll('td');
      if (tds.length >= 8) {
        const row = `<tr>
          <td>${tds[0].textContent}</td>
          <td>${tds[2].textContent}</td>
          <td>${tds[3].textContent}</td>
          <td>${tds[4].textContent}</td>
          <td>${tds[5].textContent}</td>
          <td>${tds[6].textContent}</td>
          <td>${tds[7].textContent}</td>
        </tr>`;
        body.insertAdjacentHTML('beforeend', row);
      }
    });
  }
  fetchBalance();
  fetchMyTransactions();
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', ['title' => 'User'], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/devsheikhit/public_html/vyx.dev.sheikhit.net/resources/views/user/panel.blade.php ENDPATH**/ ?>