<?php $__env->startSection('content'); ?>
<h3 class="mb-3">Callback Inspector</h3>
<p class="text-muted mb-3">Use this page to test and view what the server receives on a callback: URL, method, headers, query, body, and parsed JSON.</p>

<div class="card mb-4">
  <div class="card-body">
    <form method="post" action="<?php echo e(url('/tools/callback-inspector')); ?>">
      <?php echo csrf_field(); ?>
      <div class="mb-3">
        <label class="form-label">Body (JSON or form data)</label>
        <textarea name="body_text" class="form-control" rows="6" placeholder='{"example":"value"}'></textarea>
      </div>
      <div class="mb-3">
        <button type="submit" class="btn btn-primary">Send POST</button>
        <a href="<?php echo e(url('/tools/callback-inspector')); ?>" class="btn btn-secondary">Send GET</a>
        <button type="button" id="sendJsonBtn" class="btn btn-outline-primary">Send JSON POST (AJAX)</button>
      </div>
      <p class="small text-muted mb-0">Tip: For JSON body, use external tools (curl/Postman) with Content-Type application/json.</p>
    </form>
    <div class="mt-3" id="ajaxResultCard" style="display:none;">
      <div class="card">
        <div class="card-header">AJAX Response (format=json)</div>
        <div class="card-body">
          <pre class="mb-0" id="ajaxResult"></pre>
        </div>
      </div>
    </div>
  </div>
 </div>

<div class="row g-3">
  <div class="col-md-6">
    <div class="card">
      <div class="card-header">Request URL</div>
      <div class="card-body">
        <pre class="mb-0"><?php echo e($url); ?></pre>
      </div>
    </div>
  </div>
  <div class="col-md-6">
    <div class="card">
      <div class="card-header">Request Method & IP</div>
      <div class="card-body">
        <pre class="mb-0"><?php echo e($method); ?> | <?php echo e($ip); ?></pre>
      </div>
    </div>
  </div>
  <div class="col-md-6">
    <div class="card">
      <div class="card-header">Headers</div>
      <div class="card-body">
        <pre class="mb-0"><?php echo e(json_encode($headers, JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE)); ?></pre>
      </div>
    </div>
  </div>
  <div class="col-md-6">
    <div class="card">
      <div class="card-header">Query Params</div>
      <div class="card-body">
        <pre class="mb-0"><?php echo e(json_encode($query, JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE)); ?></pre>
      </div>
    </div>
  </div>
  <div class="col-md-6">
    <div class="card">
      <div class="card-header">Parsed Payload (request()->all())</div>
      <div class="card-body">
        <pre class="mb-0"><?php echo e(json_encode($payload, JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE)); ?></pre>
      </div>
    </div>
  </div>
  <div class="col-md-6">
    <div class="card">
      <div class="card-header">Parsed JSON (request()->json())</div>
      <div class="card-body">
        <pre class="mb-0"><?php echo e(json_encode($json, JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE)); ?></pre>
      </div>
    </div>
  </div>
  <div class="col-md-12">
    <div class="card">
      <div class="card-header">Raw Body</div>
      <div class="card-body">
        <pre class="mb-0"><?php echo e($raw); ?></pre>
      </div>
    </div>
  </div>
</div>
<script>
document.getElementById('sendJsonBtn').addEventListener('click', async function () {
  const ta = document.querySelector('textarea[name="body_text"]');
  const bodyText = ta ? ta.value.trim() : '';
  if (!bodyText) {
    alert('Please enter JSON in the textarea.');
    return;
  }
  try {
    JSON.parse(bodyText);
  } catch (e) {
    alert('Invalid JSON');
    return;
  }
  const res = await fetch('<?php echo e(url('/tools/callback-inspector')); ?>?format=json', {
    method: 'POST',
    headers: { 'Content-Type': 'application/json' },
    body: bodyText
  });
  const data = await res.json();
  document.getElementById('ajaxResult').textContent = JSON.stringify(data, null, 2);
  document.getElementById('ajaxResultCard').style.display = 'block';
});
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', ['title' => 'Callback Inspector'], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH E:\Office Project\Laravel Web Development\vyx\resources\views/admin/callback_inspector.blade.php ENDPATH**/ ?>