<?php $__env->startSection('content'); ?>
<style>
  .chips { gap: .5rem; flex-wrap: wrap; }
  .chip { border-radius: 999px; padding: .3rem .75rem; border: 1px solid #dee2e6; font-size: .85rem; text-decoration: none; }
  .chip:hover, .chip:focus { text-decoration: none; }
  .chip.active { background: #0d6efd; color: #fff; border-color: #0d6efd; }
  .game-card { transition: transform .2s ease, box-shadow .2s ease; overflow: hidden; border: 0; border-radius: .75rem; background: #111; color: #fff; }
  .game-card:hover { transform: translateY(-4px); box-shadow: 0 1.25rem 1.75rem rgba(0,0,0,.2); }
  .thumb-wrap { position: relative; }
  .ratio-16x9 { aspect-ratio: 16/9; }
  .game-thumb { width: 100%; height: 100%; object-fit: cover; display: block; }
  .thumb-overlay { position: absolute; inset: 0; background: linear-gradient(to top, rgba(0,0,0,.65), rgba(0,0,0,.15)); }
  .badge-provider { position: absolute; left: .5rem; top: .5rem; background: rgba(0,0,0,.7); }
  .title-overlay { position: absolute; left: .75rem; right: .75rem; bottom: .75rem; font-weight: 600; }
  .card-body { background: #1a1a1a; }
</style>
<div class="mb-3">
  <div class="d-flex justify-content-between align-items-center">
    <h2 class="mb-2">Games</h2>
    <?php if(auth()->guard()->check()): ?>
      <div class="d-flex align-items-center gap-2">
        <span id="balanceInline" class="badge text-bg-secondary">Loading...</span>
        <a href="<?php echo e(url('/user')); ?>" class="btn btn-outline-secondary btn-sm">Profile</a>
      </div>
    <?php else: ?>
      <div class="d-flex align-items-center gap-2">
        <a href="<?php echo e(url('/login')); ?>" class="btn btn-outline-secondary btn-sm">Login</a>
        <a href="<?php echo e(url('/register')); ?>" class="btn btn-primary btn-sm">Register</a>
      </div>
    <?php endif; ?>
  </div>
  <form method="get" action="<?php echo e(url('/games')); ?>" class="row g-2 align-items-end mb-2" id="filtersForm">
    <div class="col-sm-6 col-md-4">
      <label class="form-label">Search</label>
      <input type="text" name="q" value="<?php echo e($q ?? request()->query('q')); ?>" class="form-control" placeholder="Search games" id="liveSearch">
      <?php if($category): ?><input type="hidden" name="category" value="<?php echo e($category); ?>"><?php endif; ?>
    </div>
    <div class="col-sm-4 col-md-3">
      <div class="form-check mt-4">
        <input class="form-check-input" type="checkbox" value="1" id="hasImage" name="has_image" <?php echo e(($hasImage ?? (request()->query('has_image') ? true : false)) ? 'checked' : ''); ?>>
        <label class="form-check-label" for="hasImage">Only games with images</label>
      </div>
    </div>
    <div class="col-sm-4 col-md-3">
      <label class="form-label">Game Type</label>
      <select class="form-select" name="game_type" id="gameType">
        <option value="">All</option>
        <?php $__currentLoopData = ($gameTypes ?? collect()); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $t): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
          <?php $val = is_object($t) ? (string)($t->gt ?? $t->value ?? '') : (string)$t; ?>
          <?php if($val !== ''): ?>
            <option value="<?php echo e($val); ?>" <?php echo e((($gameType ?? request()->query('game_type')) === $val) ? 'selected' : ''); ?>><?php echo e($val); ?></option>
          <?php endif; ?>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
      </select>
    </div>
    <div class="col-sm-2 col-md-2">
      <button class="btn btn-primary w-100 mt-4" type="submit">Filter</button>
    </div>
  </form>
  <div class="d-flex chips">
    <?php $activeCat = $category ? (string)$category : ''; ?>
    <a href="<?php echo e(url('/games')); ?>" class="chip <?php echo e($activeCat === '' ? 'active' : ''); ?>">All</a>
    <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $c): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
      <?php $name = is_object($c) ? $c->name : (string)$c; ?>
      <?php $label = isset($categoryLabels) && is_array($categoryLabels) ? ($categoryLabels[$name] ?? $name) : preg_replace('/^AG_(HOT_)?/', '', $name); ?>
      <a href="<?php echo e(url('/games')); ?>?category=<?php echo e($name); ?>" class="chip <?php echo e(strcasecmp($activeCat, $name) === 0 ? 'active' : ''); ?>"><?php echo e($label); ?></a>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
  </div>
</div>

<?php if(request()->query('debug') == '1' && isset($debug)): ?>
  <div class="card mb-3">
    <div class="card-body">
      <div class="d-flex justify-content-between align-items-center"><strong>Debug</strong><span class="badge text-bg-info">Provider: <?php echo e($debug['provider'] ?? ''); ?></span></div>
      <div class="mt-2">Status: <?php echo e($debug['status'] ?? ''); ?>, Count: <?php echo e($debug['count'] ?? 0); ?>, Reason: <?php echo e($debug['reason'] ?? ''); ?></div>
      <div class="mt-2">Base URL: <?php echo e($debug['base_url'] ?? ''); ?></div>
      <div class="mt-1">Primary Path: <?php echo e($debug['primary_path'] ?? ''); ?></div>
      <?php if(!empty($debug['candidates'])): ?>
        <div class="mt-1">Candidates: <?php echo e(implode(', ', $debug['candidates'])); ?></div>
      <?php endif; ?>
      <?php if(!empty($debug['attempts'])): ?>
      <div class="table-responsive mt-2">
        <table class="table table-sm">
          <thead><tr><th>URL</th><th>Method</th><th>Status</th></tr></thead>
          <tbody>
            <?php $__currentLoopData = $debug['attempts']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $a): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
              <tr><td><?php echo e($a['url'] ?? ''); ?></td><td><?php echo e($a['method'] ?? ''); ?></td><td><?php echo e($a['status'] ?? ''); ?></td></tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
          </tbody>
        </table>
      </div>
      <?php endif; ?>
      <?php if(!empty($debug['headers'])): ?>
        <div class="mt-2"><strong>Response Headers</strong></div>
        <div class="table-responsive mt-1">
          <table class="table table-sm">
            <thead><tr><th>Header</th><th>Value</th></tr></thead>
            <tbody>
              <?php $__currentLoopData = $debug['headers']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $hk => $hv): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr><td><?php echo e($hk); ?></td><td><?php echo e(is_array($hv) ? implode(', ', $hv) : $hv); ?></td></tr>
              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
          </table>
        </div>
      <?php endif; ?>
      <?php if(!empty($debug['body'])): ?>
        <div class="mt-2"><strong>Response</strong></div>
        <pre class="mt-1" style="white-space: pre-wrap; word-break: break-word;"><?php echo e($debug['body']); ?></pre>
      <?php endif; ?>
    </div>
  </div>
<?php endif; ?>

<?php if($games->count() === 0): ?>
  <div class="alert alert-info">No games available.</div>
<?php else: ?>
  <div class="row g-3" id="gamesGrid">
    <?php $__currentLoopData = $games; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $g): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
      <div class="col-12 col-sm-6 col-md-4 col-lg-3">
        <div class="card h-100 game-card">
          <div class="thumb-wrap ratio-16x9">
            <?php if($g->thumbnail_url): ?>
              <img src="<?php echo e($g->thumbnail_url); ?>" alt="<?php echo e($g->name); ?>" class="game-thumb" loading="lazy">
            <?php else: ?>
              <div class="d-flex align-items-center justify-content-center game-thumb" style="background:#222;color:#bbb;">No Image</div>
            <?php endif; ?>
            <span class="badge badge-provider text-bg-dark"><?php echo e($g->provider_key); ?></span>
            <div class="thumb-overlay"></div>
            <div class="title-overlay"><?php echo e($g->name); ?></div>
          </div>
          <div class="card-body d-flex flex-column">
            <form method="post" action="<?php echo e(url('/games/'.$g->provider_key.'/launch')); ?>" target="_blank" class="mt-auto">
              <?php echo csrf_field(); ?>
              <input type="hidden" name="player_id" value="<?php echo e($playerId ?? (auth()->user()->player->id ?? 1)); ?>">
              <input type="hidden" name="game_code" value="<?php echo e($g->code); ?>">
              <input type="hidden" name="currency" value="<?php echo e(env('GAMES_DEFAULT_CURRENCY', 'BD_BDT')); ?>">
              <button type="submit" class="btn btn-primary w-100">Play</button>
            </form>
          </div>
        </div>
      </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
  </div>
  <div class="mt-3">
    <style>.pagination .page-link svg{width:1rem;height:1rem}</style>
    <?php echo e($games->onEachSide(1)->links('pagination::bootstrap-5')); ?>

  </div>
  <script>
    const grid = document.getElementById('gamesGrid');
    const search = document.getElementById('liveSearch');
    const hasImage = document.getElementById('hasImage');
    const gameType = document.getElementById('gameType');
    const filtersForm = document.getElementById('filtersForm');
    const balanceInline = document.getElementById('balanceInline');
    let timer = null;
    function render(items) {
      if (!Array.isArray(items)) return;
      const html = items.map(g => {
        const img = g.thumbnail_url ? `<img src=\"${g.thumbnail_url}\" alt=\"${g.name}\" class=\"game-thumb\" loading=\"lazy\">` : `<div class=\"d-flex align-items-center justify-content-center game-thumb\" style=\"background:#222;color:#bbb;\">No Image</div>`;
        return `<div class=\"col-12 col-sm-6 col-md-4 col-lg-3\">
          <div class=\"card h-100 game-card\">
            <div class=\"thumb-wrap ratio-16x9\">
              ${img}
              <span class=\"badge badge-provider text-bg-dark\">${g.provider_key}</span>
              <div class=\"thumb-overlay\"></div>
              <div class=\"title-overlay\">${g.name}</div>
            </div>
            <div class=\"card-body d-flex flex-column\">
              <form method=\"post\" action=\"/games/${g.provider_key}/launch\" target=\"_blank\" class=\"mt-auto\">
                <input type=\"hidden\" name=\"_token\" value=\"<?php echo e(csrf_token()); ?>\">
                <input type=\"hidden\" name=\"player_id\" value=\"<?php echo e($playerId ?? (auth()->user()->player->id ?? 1)); ?>\">
                <input type=\"hidden\" name=\"game_code\" value=\"${g.code}\">
                <input type=\"hidden\" name=\"currency\" value=\"<?php echo e(env('GAMES_DEFAULT_CURRENCY', 'BD_BDT')); ?>\">
                <button type=\"submit\" class=\"btn btn-primary w-100\">Play</button>
              </form>
            </div>
          </div>
        </div>`;
      }).join('');
      grid.innerHTML = html || `<div class=\"col-12\"><div class=\"alert alert-info\">No games found.</div></div>`;
    }
    function liveFetch() {
      const q = search.value.trim();
      const params = new URLSearchParams();
      if (q.length >= 1) params.set('q', q);
      const cat = '<?php echo e($category ?? ''); ?>';
      if (cat) params.set('category', cat);
      if (hasImage.checked) params.set('has_image', '1');
      const gt = gameType ? gameType.value.trim() : '';
      if (gt) params.set('game_type', gt);
      fetch('/games/search?' + params.toString(), { headers: { 'Accept': 'application/json' }})
        .then(r => r.json())
        .then(j => render(j.items || []))
        .catch(() => {});
    }
    search.addEventListener('input', () => {
      clearTimeout(timer);
      timer = setTimeout(liveFetch, 250);
    });
    hasImage.addEventListener('change', () => {
      liveFetch();
    });
    if (gameType) {
      gameType.addEventListener('change', () => {
        liveFetch();
      });
    }
    filtersForm.addEventListener('submit', (e) => {
      const q = search.value.trim();
      if (q.length >= 1) {
        e.preventDefault();
        liveFetch();
      }
    });
    async function fetchInlineBalance() {
      if (!balanceInline) return;
      try {
        const r = await fetch('/wallet/balance?currency=<?php echo e(env('GAMES_DEFAULT_CURRENCY', 'BD_BDT')); ?>', { headers: { 'Accept': 'application/json' }});
        const j = await r.json();
        const amt = typeof j.balance === 'number' ? j.balance.toFixed(2) : (j.balance ?? '');
        balanceInline.textContent = `${amt} ${j.currency || ''}`.trim();
      } catch (_) {
        balanceInline.textContent = '—';
      }
    }
    fetchInlineBalance();
  </script>
<?php endif; ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', ['title' => 'Games'], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH E:\Office Project\Laravel Web Development\vyx\resources\views/games/index.blade.php ENDPATH**/ ?>