@extends('layouts.app', ['title' => 'AGSoft Reports'])

@section('content')
<div class="d-flex align-items-center justify-content-between mb-3">
  <h3 class="mb-0">AGSoft Integration Report</h3>
  <a class="btn btn-sm btn-outline-secondary" href="{{ url('/reports/agsoft?format=json') }}">View JSON</a>
 </div>

<div class="card mb-3"><div class="card-body">
  <div>Base URL: <code>{{ $base_url }}</code></div>
</div></div>

<div class="row g-3">
  <div class="col-md-6">
    <div class="card h-100"><div class="card-body">
      <h5 class="card-title">Providers</h5>
      <div>Status: <span class="badge text-bg-{{ (($results['providers']['status'] ?? 0) === 200) ? 'success' : 'danger' }}">{{ $results['providers']['status'] ?? 0 }}</span></div>
      <pre class="mt-2" style="max-height:240px;overflow:auto">{{ is_array($results['providers']['body'] ?? null) ? json_encode($results['providers']['body']) : ($results['providers']['body'] ?? '') }}</pre>
    </div></div>
  </div>
  <div class="col-md-6">
    <div class="card h-100"><div class="card-body">
      <h5 class="card-title">Categories</h5>
      <div>Status: <span class="badge text-bg-{{ (($results['categories']['status'] ?? 0) === 200) ? 'success' : 'danger' }}">{{ $results['categories']['status'] ?? 0 }}</span></div>
      <pre class="mt-2" style="max-height:240px;overflow:auto">{{ is_array($results['categories']['body'] ?? null) ? json_encode($results['categories']['body']) : ($results['categories']['body'] ?? '') }}</pre>
    </div></div>
  </div>
  <div class="col-md-6">
    <div class="card h-100"><div class="card-body">
      <h5 class="card-title">Games</h5>
      <div>Status: <span class="badge text-bg-{{ (($results['games']['status'] ?? 0) === 200) ? 'success' : 'danger' }}">{{ $results['games']['status'] ?? 0 }}</span></div>
      <pre class="mt-2" style="max-height:240px;overflow:auto">{{ is_array($results['games']['body'] ?? null) ? json_encode($results['games']['body']) : ($results['games']['body'] ?? '') }}</pre>
    </div></div>
  </div>
  <div class="col-md-6">
    <div class="card h-100"><div class="card-body">
      <h5 class="card-title">Merchant Info</h5>
      <div>Status: <span class="badge text-bg-{{ (($results['merchant_info']['status'] ?? 0) === 200) ? 'success' : 'danger' }}">{{ $results['merchant_info']['status'] ?? 0 }}</span></div>
      <pre class="mt-2" style="max-height:240px;overflow:auto">{{ is_array($results['merchant_info']['body'] ?? null) ? json_encode($results['merchant_info']['body']) : ($results['merchant_info']['body'] ?? '') }}</pre>
    </div></div>
  </div>
</div>

<div class="card mt-3"><div class="card-body">
  <h5 class="card-title">Recent Logs</h5>
  @if(!empty($logs))
    <pre style="max-height:300px;overflow:auto">{{ implode("\n", $logs) }}</pre>
  @else
    <div>No logs found.</div>
  @endif
</div></div>
@endsection
