@extends('layouts.app', ['title' => 'Games'])

@section('content')
<style>
  .chips { gap: .5rem; flex-wrap: wrap; }
  .chip { border-radius: 999px; padding: .3rem .75rem; border: 1px solid #dee2e6; font-size: .85rem; text-decoration: none; }
  .chip:hover, .chip:focus { text-decoration: none; }
  .chip.active { background: #0d6efd; color: #fff; border-color: #0d6efd; }
  .game-card { transition: transform .2s ease, box-shadow .2s ease; overflow: hidden; border: 0; border-radius: .75rem; background: #111; color: #fff; }
  .game-card:hover { transform: translateY(-4px); box-shadow: 0 1.25rem 1.75rem rgba(0,0,0,.2); }
  .thumb-wrap { position: relative; }
  .ratio-16x9 { aspect-ratio: 16/9; }
  .game-thumb { width: 100%; height: 100%; object-fit: cover; display: block; }
  .thumb-overlay { position: absolute; inset: 0; background: linear-gradient(to top, rgba(0,0,0,.65), rgba(0,0,0,.15)); }
  .badge-provider { position: absolute; left: .5rem; top: .5rem; background: rgba(0,0,0,.7); }
  .title-overlay { position: absolute; left: .75rem; right: .75rem; bottom: .75rem; font-weight: 600; }
  .card-body { background: #1a1a1a; }
</style>
<div class="mb-3">
  <div class="d-flex justify-content-between align-items-center">
    <h2 class="mb-2">Games</h2>
    @auth
      <div class="d-flex align-items-center gap-2">
        <span id="balanceInline" class="badge text-bg-secondary">Loading...</span>
        <a href="{{ url('/user') }}" class="btn btn-outline-secondary btn-sm">Profile</a>
      </div>
    @else
      <div class="d-flex align-items-center gap-2">
        <a href="{{ url('/login') }}" class="btn btn-outline-secondary btn-sm">Login</a>
        <a href="{{ url('/register') }}" class="btn btn-primary btn-sm">Register</a>
      </div>
    @endauth
  </div>
  <form method="get" action="{{ url('/games') }}" class="row g-2 align-items-end mb-2" id="filtersForm">
    <div class="col-sm-6 col-md-4">
      <label class="form-label">Search</label>
      <input type="text" name="q" value="{{ $q ?? request()->query('q') }}" class="form-control" placeholder="Search games" id="liveSearch">
      @if($category)<input type="hidden" name="category" value="{{ $category }}">@endif
    </div>
    <div class="col-sm-4 col-md-3">
      <div class="form-check mt-4">
        <input class="form-check-input" type="checkbox" value="1" id="hasImage" name="has_image" {{ ($hasImage ?? (request()->query('has_image') ? true : false)) ? 'checked' : '' }}>
        <label class="form-check-label" for="hasImage">Only games with images</label>
      </div>
    </div>
    <div class="col-sm-4 col-md-3">
      <label class="form-label">Game Type</label>
      <select class="form-select" name="game_type" id="gameType">
        <option value="">All</option>
        @foreach(($gameTypes ?? collect()) as $t)
          @php $val = is_object($t) ? (string)($t->gt ?? $t->value ?? '') : (string)$t; @endphp
          @if($val !== '')
            <option value="{{ $val }}" {{ (($gameType ?? request()->query('game_type')) === $val) ? 'selected' : '' }}>{{ $val }}</option>
          @endif
        @endforeach
      </select>
    </div>
    <div class="col-sm-2 col-md-2">
      <button class="btn btn-primary w-100 mt-4" type="submit">Filter</button>
    </div>
  </form>
  <div class="d-flex chips">
    @php $activeCat = $category ? (string)$category : ''; @endphp
    <a href="{{ url('/games') }}" class="chip {{ $activeCat === '' ? 'active' : '' }}">All</a>
    @foreach($categories as $c)
      @php $name = is_object($c) ? $c->name : (string)$c; @endphp
      @php $label = isset($categoryLabels) && is_array($categoryLabels) ? ($categoryLabels[$name] ?? $name) : preg_replace('/^AG_(HOT_)?/', '', $name); @endphp
      <a href="{{ url('/games') }}?category={{ $name }}" class="chip {{ strcasecmp($activeCat, $name) === 0 ? 'active' : '' }}">{{ $label }}</a>
    @endforeach
  </div>
</div>

@if(request()->query('debug') == '1' && isset($debug))
  <div class="card mb-3">
    <div class="card-body">
      <div class="d-flex justify-content-between align-items-center"><strong>Debug</strong><span class="badge text-bg-info">Provider: {{ $debug['provider'] ?? '' }}</span></div>
      <div class="mt-2">Status: {{ $debug['status'] ?? '' }}, Count: {{ $debug['count'] ?? 0 }}, Reason: {{ $debug['reason'] ?? '' }}</div>
      <div class="mt-2">Base URL: {{ $debug['base_url'] ?? '' }}</div>
      <div class="mt-1">Primary Path: {{ $debug['primary_path'] ?? '' }}</div>
      @if(!empty($debug['candidates']))
        <div class="mt-1">Candidates: {{ implode(', ', $debug['candidates']) }}</div>
      @endif
      @if(!empty($debug['attempts']))
      <div class="table-responsive mt-2">
        <table class="table table-sm">
          <thead><tr><th>URL</th><th>Method</th><th>Status</th></tr></thead>
          <tbody>
            @foreach($debug['attempts'] as $a)
              <tr><td>{{ $a['url'] ?? '' }}</td><td>{{ $a['method'] ?? '' }}</td><td>{{ $a['status'] ?? '' }}</td></tr>
            @endforeach
          </tbody>
        </table>
      </div>
      @endif
      @if(!empty($debug['headers']))
        <div class="mt-2"><strong>Response Headers</strong></div>
        <div class="table-responsive mt-1">
          <table class="table table-sm">
            <thead><tr><th>Header</th><th>Value</th></tr></thead>
            <tbody>
              @foreach($debug['headers'] as $hk => $hv)
                <tr><td>{{ $hk }}</td><td>{{ is_array($hv) ? implode(', ', $hv) : $hv }}</td></tr>
              @endforeach
            </tbody>
          </table>
        </div>
      @endif
      @if(!empty($debug['body']))
        <div class="mt-2"><strong>Response</strong></div>
        <pre class="mt-1" style="white-space: pre-wrap; word-break: break-word;">{{ $debug['body'] }}</pre>
      @endif
    </div>
  </div>
@endif

@if($games->count() === 0)
  <div class="alert alert-info">No games available.</div>
@else
  <div class="row g-3" id="gamesGrid">
    @foreach($games as $g)
      <div class="col-12 col-sm-6 col-md-4 col-lg-3">
        <div class="card h-100 game-card">
          <div class="thumb-wrap ratio-16x9">
            @if($g->thumbnail_url)
              <img src="{{ $g->thumbnail_url }}" alt="{{ $g->name }}" class="game-thumb" loading="lazy">
            @else
              <div class="d-flex align-items-center justify-content-center game-thumb" style="background:#222;color:#bbb;">No Image</div>
            @endif
            <span class="badge badge-provider text-bg-dark">{{ $g->provider_key }}</span>
            <div class="thumb-overlay"></div>
            <div class="title-overlay">{{ $g->name }}</div>
          </div>
          <div class="card-body d-flex flex-column">
            <form method="post" action="{{ url('/games/'.$g->provider_key.'/launch') }}" target="_blank" class="mt-auto">
              @csrf
              <input type="hidden" name="player_id" value="{{ $playerId ?? (auth()->user()->player->id ?? 1) }}">
              <input type="hidden" name="game_code" value="{{ $g->code }}">
              <input type="hidden" name="currency" value="{{ env('GAMES_DEFAULT_CURRENCY', 'BD_BDT') }}">
              <button type="submit" class="btn btn-primary w-100">Play</button>
            </form>
          </div>
        </div>
      </div>
    @endforeach
  </div>
  <div class="mt-3">
    <style>.pagination .page-link svg{width:1rem;height:1rem}</style>
    {{ $games->onEachSide(1)->links('pagination::bootstrap-5') }}
  </div>
  <script>
    const grid = document.getElementById('gamesGrid');
    const search = document.getElementById('liveSearch');
    const hasImage = document.getElementById('hasImage');
    const gameType = document.getElementById('gameType');
    const filtersForm = document.getElementById('filtersForm');
    const balanceInline = document.getElementById('balanceInline');
    let timer = null;
    function render(items) {
      if (!Array.isArray(items)) return;
      const html = items.map(g => {
        const img = g.thumbnail_url ? `<img src=\"${g.thumbnail_url}\" alt=\"${g.name}\" class=\"game-thumb\" loading=\"lazy\">` : `<div class=\"d-flex align-items-center justify-content-center game-thumb\" style=\"background:#222;color:#bbb;\">No Image</div>`;
        return `<div class=\"col-12 col-sm-6 col-md-4 col-lg-3\">
          <div class=\"card h-100 game-card\">
            <div class=\"thumb-wrap ratio-16x9\">
              ${img}
              <span class=\"badge badge-provider text-bg-dark\">${g.provider_key}</span>
              <div class=\"thumb-overlay\"></div>
              <div class=\"title-overlay\">${g.name}</div>
            </div>
            <div class=\"card-body d-flex flex-column\">
              <form method=\"post\" action=\"/games/${g.provider_key}/launch\" target=\"_blank\" class=\"mt-auto\">
                <input type=\"hidden\" name=\"_token\" value=\"{{ csrf_token() }}\">
                <input type=\"hidden\" name=\"player_id\" value=\"{{ $playerId ?? (auth()->user()->player->id ?? 1) }}\">
                <input type=\"hidden\" name=\"game_code\" value=\"${g.code}\">
                <input type=\"hidden\" name=\"currency\" value=\"{{ env('GAMES_DEFAULT_CURRENCY', 'BD_BDT') }}\">
                <button type=\"submit\" class=\"btn btn-primary w-100\">Play</button>
              </form>
            </div>
          </div>
        </div>`;
      }).join('');
      grid.innerHTML = html || `<div class=\"col-12\"><div class=\"alert alert-info\">No games found.</div></div>`;
    }
    function liveFetch() {
      const q = search.value.trim();
      const params = new URLSearchParams();
      if (q.length >= 1) params.set('q', q);
      const cat = '{{ $category ?? '' }}';
      if (cat) params.set('category', cat);
      if (hasImage.checked) params.set('has_image', '1');
      const gt = gameType ? gameType.value.trim() : '';
      if (gt) params.set('game_type', gt);
      fetch('/games/search?' + params.toString(), { headers: { 'Accept': 'application/json' }})
        .then(r => r.json())
        .then(j => render(j.items || []))
        .catch(() => {});
    }
    search.addEventListener('input', () => {
      clearTimeout(timer);
      timer = setTimeout(liveFetch, 250);
    });
    hasImage.addEventListener('change', () => {
      liveFetch();
    });
    if (gameType) {
      gameType.addEventListener('change', () => {
        liveFetch();
      });
    }
    filtersForm.addEventListener('submit', (e) => {
      const q = search.value.trim();
      if (q.length >= 1) {
        e.preventDefault();
        liveFetch();
      }
    });
    async function fetchInlineBalance() {
      if (!balanceInline) return;
      try {
        const r = await fetch('/wallet/balance?currency={{ env('GAMES_DEFAULT_CURRENCY', 'BD_BDT') }}', { headers: { 'Accept': 'application/json' }});
        const j = await r.json();
        const amt = typeof j.balance === 'number' ? j.balance.toFixed(2) : (j.balance ?? '');
        balanceInline.textContent = `${amt} ${j.currency || ''}`.trim();
      } catch (_) {
        balanceInline.textContent = '—';
      }
    }
    fetchInlineBalance();
  </script>
@endif
@endsection
