@extends('layouts.app', ['title' => 'Games API Docs (English)'])

@section('content')
<div class="d-flex align-items-center justify-content-between mb-3">
  <h3 class="mb-0">Games API Documentation (English)</h3>
  <button class="btn btn-outline-secondary btn-sm" onclick="window.print()">Print / Save as PDF</button>
</div>

<div class="card mb-3"><div class="card-body">
  <h5>Overview</h5>
  <p>Integrates the Agsoft Games provider for game launch, balance, transactions, and callbacks.</p>
  <p>Base URL: <code>{{ config('games.providers.agsoftgames.base_url') }}</code></p>
  <p>Headers: <code>X-MERCHANT-CODE</code>, <code>X-TIMESTAMP</code>, <code>X-NONCE</code>, <code>X-CONTENT-PROCESSING-TYPE</code>=<code>HmacSHA256</code>, <code>X-SIGN</code>.</p>
</div></div>

<div class="card mb-3"><div class="card-body">
  <h5>Endpoints (Provider)</h5>
  <ul>
    <li>Providers: <code>{{ config('games.providers.agsoftgames.endpoints.providers') }}</code></li>
    <li>Categories: <code>{{ config('games.providers.agsoftgames.endpoints.categories') }}</code></li>
    <li>Games: <code>{{ config('games.providers.agsoftgames.endpoints.games') }}</code></li>
    <li>Game URL: <code>{{ config('games.providers.agsoftgames.endpoints.launch') }}</code></li>
    <li>Merchant Info: <code>{{ config('games.providers.agsoftgames.endpoints.merchant_info') }}</code></li>
  </ul>

</div></div>

<div class="card mb-3"><div class="card-body">
  <h5>Requests (App → Provider)</h5>
  <p>App proxies requests to provider under <code>/api/games/{provider}</code>.</p>
  <ul>
    <li><code>POST /api/games/agsoftgames/launch</code> — body: <code>{ player_id, game_code, currency }</code></li>
    <li><code>GET /api/games/agsoftgames/balance?player_id=&amp;currency=</code></li>
    <li><code>POST /api/games/agsoftgames/debit</code> — body: <code>{ player_id, amount, currency, tx_id }</code></li>
    <li><code>POST /api/games/agsoftgames/credit</code> — body: <code>{ player_id, amount, currency, tx_id }</code></li>
    <li><code>POST /api/games/agsoftgames/rollback</code> — body: <code>{ tx_id }</code></li>
  </ul>
</div></div>

<div class="card mb-3"><div class="card-body">
  <h5>Callback (Provider → App)</h5>
  <p>URL: <code>{{ rtrim(config('games.callback.base'), '/') }}/api/games/agsoftgames/callback</code></p>
  <p>Headers: <code>X-Signature</code> = HMAC-SHA256 of raw JSON payload using <code>{{ env('GAMES_AGULA_SECRET') }}</code></p>
  <p>Allowed IPs: <code>{{ env('GAMES_AGSOFT_ALLOWED_IPS') }}</code></p>
  <p>Example payload:</p>
  <pre>{
  "event": "transaction",
  "tx_id": "unique-tx-123",
  "type": "credit",
  "amount": 5,
  "currency": "USD",
  "player_id": 1,
  "session_id": "sess-abc"
}</pre>
  <p>Processing logic updates wallet and records transaction idempotently.</p>
</div></div>

<div class="card mb-3"><div class="card-body">
  <h5>Errors</h5>
  <ul>
    <li><code>404</code> — Path not found; set correct catalog/endpoint paths in <code>.env</code>.</li>
    <li><code>401</code> — Unauthorized; verify API key/headers.</li>
    <li><code>403</code> — IP not allowed for callback.</li>
    <li><code>0</code> — Connection error (network/timeouts).</li>
  </ul>
</div></div>

<div class="card"><div class="card-body">
  <h5>Configuration (.env)</h5>
  <pre>APP_URL={{ env('APP_URL') }}
GAMES_CALLBACK_BASE={{ env('GAMES_CALLBACK_BASE') }}
GAMES_AGULA_BASE_URL={{ env('GAMES_AGULA_BASE_URL') }}
GAMES_AGULA_SECRET={{ env('GAMES_AGULA_SECRET') }}
GAMES_MERCHANT_NAME={{ env('GAMES_MERCHANT_NAME') }}
GAMES_MERCHANT_CODE={{ env('GAMES_MERCHANT_CODE') }}
GAMES_PROVIDERS_PATH={{ env('GAMES_PROVIDERS_PATH') }}
GAMES_CATEGORIES_PATH={{ env('GAMES_CATEGORIES_PATH') }}
GAMES_CATALOG_PATH={{ env('GAMES_CATALOG_PATH') }}
GAMES_CATALOG_PATHS={{ env('GAMES_CATALOG_PATHS') }}
GAMES_LAUNCH_PATH={{ env('GAMES_LAUNCH_PATH') }}
GAMES_MERCHANT_INFO_PATH={{ env('GAMES_MERCHANT_INFO_PATH') }}
GAMES_AGSOFT_ALLOWED_IPS={{ env('GAMES_AGSOFT_ALLOWED_IPS') }}</pre>
</div></div>
@endsection
