@extends('layouts.app', ['title' => 'Login'])

@section('content')
<div class="row justify-content-center">
  <div class="col-12 col-md-6 col-lg-4">
    <h3 class="mb-3">Login</h3>
    <form method="post" action="{{ url('/login') }}" class="card card-body">
      @csrf
      <div class="mb-3">
        <label class="form-label">Email</label>
        <input type="email" name="email" class="form-control" required>
      </div>
      <div class="mb-3">
        <label class="form-label">Password</label>
        <input type="password" name="password" class="form-control" required>
      </div>
      <div class="form-check mb-3">
        <input class="form-check-input" type="checkbox" name="remember" id="remember">
        <label class="form-check-label" for="remember">Remember me</label>
      </div>
      <button type="submit" class="btn btn-primary w-100">Login</button>
    </form>
    <div class="mt-2"><a href="{{ url('/register') }}">Create an account</a></div>
  </div>
</div>
@endsection
