@extends('layouts.app', ['title' => 'Admin • Users'])

@section('content')
<h3 class="mb-3">Users</h3>
@if(session('status'))
  <div class="alert alert-success">Recharge completed.</div>
@endif
<div class="table-responsive">
  <table class="table table-sm align-middle">
    <thead><tr><th>ID</th><th>Name</th><th>Email</th><th>Balance (Total)</th><th>Recharge</th></tr></thead>
    <tbody>
      @foreach($users as $u)
        <tr>
          <td>{{ $u->id }}</td>
          <td>{{ $u->name }}</td>
          <td>{{ $u->email }}</td>
          <td>{{ number_format((float)($balances[$u->id] ?? 0), 2) }}</td>
          <td>
            <form method="post" action="{{ url('/admin/users/'.$u->id.'/recharge') }}" class="d-flex gap-2">
              @csrf
              <input type="number" step="0.01" min="0.01" name="amount" class="form-control form-control-sm" placeholder="Amount" required>
              <select name="currency" class="form-select form-select-sm">
                <option value="{{ env('GAMES_DEFAULT_CURRENCY', 'BD_BDT') }}">{{ env('GAMES_DEFAULT_CURRENCY', 'BD_BDT') }}</option>
              </select>
              <button class="btn btn-sm btn-primary">Recharge</button>
            </form>
          </td>
        </tr>
      @endforeach
    </tbody>
  </table>
 </div>
@endsection
