@extends('layouts.app', ['title' => 'Admin • Transactions'])

@section('content')
<h3 class="mb-3">Transactions</h3>
<form method="get" action="{{ url('/admin/transactions') }}" class="row g-2 mb-3">
  <div class="col-sm-4 col-md-3">
    <label class="form-label">Player ID</label>
    <input type="number" name="player_id" value="{{ $playerId ?? '' }}" class="form-control" placeholder="Filter by player">
  </div>
  <div class="col-sm-2 col-md-2">
    <button class="btn btn-primary w-100 mt-4" type="submit">Apply</button>
  </div>
  <div class="col-sm-2 col-md-2">
    <a class="btn btn-outline-secondary w-100 mt-4" href="{{ url('/admin/transactions') }}">Reset</a>
  </div>
 </form>
<div class="card mb-3"><div class="card-body">
  <h5 class="card-title">Loss Profile (Aggregated)</h5>
  <div class="table-responsive">
    <table class="table table-sm">
      <thead><tr><th>Player</th><th>Total Debit</th><th>Total Credit</th><th>Net (Credit - Debit)</th></tr></thead>
      <tbody>
        @foreach($aggregate as $row)
          <tr>
            <td>{{ $row->player_id ?? '-' }}</td>
            <td>{{ number_format((float)($row->total_debit ?? 0), 2) }}</td>
            <td>{{ number_format((float)($row->total_credit ?? 0), 2) }}</td>
            <td>{{ number_format((float)($row->net ?? 0), 2) }}</td>
          </tr>
        @endforeach
      </tbody>
    </table>
  </div>
</div></div>
<div class="card"><div class="card-body">
  <h5 class="card-title">Recent Transactions</h5>
  <div class="table-responsive">
    <table class="table table-sm">
      <thead><tr><th>ID</th><th>Player</th><th>Provider</th><th>Type</th><th>Amount</th><th>Currency</th><th>Tx ID</th><th>Processed</th></tr></thead>
      <tbody>
        @foreach($transactions as $t)
          <tr>
            <td>{{ $t->id }}</td>
            <td>{{ $t->player_id ?? '-' }}</td>
            <td>{{ $t->provider_key }}</td>
            <td>{{ $t->type }}</td>
            <td>{{ number_format((float)$t->amount, 2) }}</td>
            <td>{{ $t->currency }}</td>
            <td>{{ $t->tx_id }}</td>
            <td>{{ $t->processed_at }}</td>
          </tr>
        @endforeach
      </tbody>
    </table>
  </div>
</div></div>
@endsection

