@extends('layouts.app', ['title' => 'Callback Inspector'])

@section('content')
<h3 class="mb-3">Callback Inspector</h3>
<p class="text-muted mb-3">Use this page to test and view what the server receives on a callback: URL, method, headers, query, body, and parsed JSON.</p>

<div class="card mb-4">
  <div class="card-body">
    <form method="post" action="{{ url('/tools/callback-inspector') }}">
      @csrf
      <div class="mb-3">
        <label class="form-label">Body (JSON or form data)</label>
        <textarea name="body_text" class="form-control" rows="6" placeholder='{"example":"value"}'></textarea>
      </div>
      <div class="mb-3">
        <button type="submit" class="btn btn-primary">Send POST</button>
        <a href="{{ url('/tools/callback-inspector') }}" class="btn btn-secondary">Send GET</a>
        <button type="button" id="sendJsonBtn" class="btn btn-outline-primary">Send JSON POST (AJAX)</button>
      </div>
      <p class="small text-muted mb-0">Tip: For JSON body, use external tools (curl/Postman) with Content-Type application/json.</p>
    </form>
    <div class="mt-3" id="ajaxResultCard" style="display:none;">
      <div class="card">
        <div class="card-header">AJAX Response (format=json)</div>
        <div class="card-body">
          <pre class="mb-0" id="ajaxResult"></pre>
        </div>
      </div>
    </div>
  </div>
 </div>

<div class="row g-3">
  <div class="col-md-6">
    <div class="card">
      <div class="card-header">Request URL</div>
      <div class="card-body">
        <pre class="mb-0">{{ $url }}</pre>
      </div>
    </div>
  </div>
  <div class="col-md-6">
    <div class="card">
      <div class="card-header">Request Method & IP</div>
      <div class="card-body">
        <pre class="mb-0">{{ $method }} | {{ $ip }}</pre>
      </div>
    </div>
  </div>
  <div class="col-md-6">
    <div class="card">
      <div class="card-header">Headers</div>
      <div class="card-body">
        <pre class="mb-0">{{ json_encode($headers, JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE) }}</pre>
      </div>
    </div>
  </div>
  <div class="col-md-6">
    <div class="card">
      <div class="card-header">Query Params</div>
      <div class="card-body">
        <pre class="mb-0">{{ json_encode($query, JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE) }}</pre>
      </div>
    </div>
  </div>
  <div class="col-md-6">
    <div class="card">
      <div class="card-header">Parsed Payload (request()->all())</div>
      <div class="card-body">
        <pre class="mb-0">{{ json_encode($payload, JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE) }}</pre>
      </div>
    </div>
  </div>
  <div class="col-md-6">
    <div class="card">
      <div class="card-header">Parsed JSON (request()->json())</div>
      <div class="card-body">
        <pre class="mb-0">{{ json_encode($json, JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE) }}</pre>
      </div>
    </div>
  </div>
  <div class="col-md-12">
    <div class="card">
      <div class="card-header">Raw Body</div>
      <div class="card-body">
        <pre class="mb-0">{{ $raw }}</pre>
      </div>
    </div>
  </div>
</div>
<script>
document.getElementById('sendJsonBtn').addEventListener('click', async function () {
  const ta = document.querySelector('textarea[name="body_text"]');
  const bodyText = ta ? ta.value.trim() : '';
  if (!bodyText) {
    alert('Please enter JSON in the textarea.');
    return;
  }
  try {
    JSON.parse(bodyText);
  } catch (e) {
    alert('Invalid JSON');
    return;
  }
  const res = await fetch('{{ url('/tools/callback-inspector') }}?format=json', {
    method: 'POST',
    headers: { 'Content-Type': 'application/json' },
    body: bodyText
  });
  const data = await res.json();
  document.getElementById('ajaxResult').textContent = JSON.stringify(data, null, 2);
  document.getElementById('ajaxResultCard').style.display = 'block';
});
</script>
@endsection
