<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\GameCategory;
use App\Models\Game;

class GameSeeder extends Seeder
{
    public function run(): void
    {
        $slots = GameCategory::firstOrCreate(['name' => 'Slots']);
        $table = GameCategory::firstOrCreate(['name' => 'Table']);
        Game::firstOrCreate(['code' => 'agsoft-demo-1'], [
            'provider_key' => 'agsoftgames',
            'name' => 'Agsoft Demo 1',
            'category_id' => $slots->id,
            'thumbnail_url' => null,
            'meta' => ['rtp' => 96.1],
            'active' => true,
        ]);
        Game::firstOrCreate(['code' => 'agsoft-demo-2'], [
            'provider_key' => 'agsoftgames',
            'name' => 'Agsoft Demo 2',
            'category_id' => $table->id,
            'thumbnail_url' => null,
            'meta' => ['rtp' => 95.5],
            'active' => true,
        ]);
    }
}

