<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('callback_events', function (Blueprint $table) {
            $table->id();
            $table->string('provider_key');
            $table->string('event_type')->nullable();
            $table->boolean('signature_valid')->default(false);
            $table->longText('payload');
            $table->timestamp('handled_at')->nullable();
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('callback_events');
    }
};

