<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('game_transactions', function (Blueprint $table) {
            $table->id();
            $table->string('provider_key');
            $table->string('tx_id')->unique();
            $table->string('session_id')->nullable();
            $table->string('type');
            $table->decimal('amount', 18, 6);
            $table->string('currency', 12);
            $table->string('status')->default('pending');
            $table->json('meta')->nullable();
            $table->timestamp('processed_at')->nullable();
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('game_transactions');
    }
};

