<?php

return [

    /*
    |--------------------------------------------------------------------------
    | Third Party Services
    |--------------------------------------------------------------------------
    |
    | This file is for storing the credentials for third party services such
    | as Mailgun, Postmark, AWS and more. This file provides the de facto
    | location for this type of information, allowing packages to have
    | a conventional file to locate the various service credentials.
    |
    */

    'postmark' => [
        'key' => env('POSTMARK_API_KEY'),
    ],

    'resend' => [
        'key' => env('RESEND_API_KEY'),
    ],

    'ses' => [
        'key' => env('AWS_ACCESS_KEY_ID'),
        'secret' => env('AWS_SECRET_ACCESS_KEY'),
        'region' => env('AWS_DEFAULT_REGION', 'us-east-1'),
    ],

    'slack' => [
        'notifications' => [
            'bot_user_oauth_token' => env('SLACK_BOT_USER_OAUTH_TOKEN'),
            'channel' => env('SLACK_BOT_USER_DEFAULT_CHANNEL'),
        ],
    ],

    'agsoft' => [
        'merchant_code' => env('AGSOFT_MERCHANT_CODE', env('GAMES_MERCHANT_CODE')),
        'secret_key'    => env('AGSOFT_SECRET_KEY', env('GAMES_AGULA_SECRET')),
        'base_url'      => env('AGSOFT_BASE_URL', env('GAMES_AGULA_BASE_URL')),
        'sign_type'     => env('AGSOFT_SIGN_TYPE', 'HmacSHA256'),
    ],

];
