<?php

return [
    'callback' => [
        'base' => env('GAMES_CALLBACK_BASE', env('APP_URL')),
    ],
    'providers' => [
        'agsoftgames' => [
            'name' => 'Agsoft Games',
            'base_url' => env('GAMES_AGULA_BASE_URL'),
            'api_key' => env('GAMES_AGULA_API_KEY'),
            'secret' => env('GAMES_AGULA_SECRET'),
            'timeout' => 10,
            'allowed_ips' => array_filter(explode(',', (string) env('GAMES_AGSOFT_ALLOWED_IPS', ''))),
            'endpoints' => [
                'providers' => env('GAMES_PROVIDERS_PATH', '/game/v5/providers'),
                'categories' => env('GAMES_CATEGORIES_PATH', '/game/v5/categories'),
                'games' => env('GAMES_CATALOG_PATH', '/game/v5/games'),
                'launch' => env('GAMES_LAUNCH_PATH', '/game/v5/game/url'),
                'merchant_info' => env('GAMES_MERCHANT_INFO_PATH', '/game/v5/merchant/info'),
                'balance' => env('GAMES_BALANCE_PATH', '/balance'),
                'debit' => env('GAMES_DEBIT_PATH', '/debit'),
                'credit' => env('GAMES_CREDIT_PATH', '/credit'),
                'rollback' => env('GAMES_ROLLBACK_PATH', '/rollback'),
                'games_candidates' => array_filter(explode(',', (string) env('GAMES_CATALOG_PATHS', ''))),
            ],
        ],
    ],
];

