<?php

namespace App\Services\Games;

use App\Services\Games\Providers\AgulaHoccyClient;

class ProviderFactory
{
    public static function make(string $provider)
    {
        $config = config('games.providers.' . $provider, []);
        if ($provider === 'agsoftgames') {
            $svc = config('services.agsoft', []);
            if (empty($config['base_url'])) {
                $config['base_url'] = (string)($svc['base_url'] ?? '');
            }
            if (empty($config['secret'])) {
                $config['secret'] = (string)($svc['secret_key'] ?? '');
            }
            if (empty($config['timeout'])) {
                $config['timeout'] = 10;
            }
            return new AgulaHoccyClient($config);
        }
        return null;
    }
}

