<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class Game extends Model
{
    protected $fillable = ['provider_key', 'code', 'name', 'category_id', 'thumbnail_url', 'meta', 'active'];

    protected $casts = [
        'meta' => 'array',
        'active' => 'boolean',
    ];

    public function category(): BelongsTo
    {
        return $this->belongsTo(GameCategory::class);
    }
}

