<?php

namespace App\Http\Middleware;

use App\Services\Games\ProviderFactory;
use Closure;
use Illuminate\Http\Request;

class ValidateProviderSignature
{
    public function handle(Request $request, Closure $next)
    {
        $provider = (string) ($request->route('provider') ?? 'agsoftgames');
        $client = ProviderFactory::make($provider);
        if (!$client) {
            return response()->json(['error' => 'invalid_provider'], 404);
        }
        $signature = $request->header('X-SIGN') ?? $request->header('X-Signature') ?? $request->header('X-SIGNATURE');
        \Illuminate\Support\Facades\Log::channel('games')->info('games.provider.callback.request', [
            'provider' => $provider,
            'method' => $request->method(),
            'ip' => $request->ip(),
            'query' => $request->query(),
            'headers' => $request->headers->all(),
            'raw' => $request->getContent(),
            'event' => 'provider_callback_request',
        ]);
        $valid = $client->verifySignature($request->getContent(), $signature, $request->headers->all());
        if (!$valid) {
            \Illuminate\Support\Facades\Log::channel('games')->warning('games.provider.callback.invalid_signature', [
                'provider' => $provider,
                'signature' => $signature,
                'event' => 'provider_callback_invalid_signature',
            ]);
            return response()->json(['error' => 'invalid_signature'], 401);
        }
        return $next($request);
    }
}
