<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;

class ValidateProviderIp
{
    public function handle(Request $request, Closure $next)
    {
        if (env('GAMES_ALLOW_ALL_IPS', false)) {
            return $next($request);
        }
        $provider = (string) ($request->route('provider') ?? 'agsoftgames');
        $ips = (array) config('games.providers.' . $provider . '.allowed_ips', []);
        \Illuminate\Support\Facades\Log::channel('games')->info('games.provider.callback.ip_check', [
            'provider' => $provider,
            'ip' => $request->ip(),
            'allowed' => $ips,
            'event' => 'provider_callback_ip_check',
        ]);
        if ($ips && !in_array($request->ip(), $ips, true)) {
            return response()->json(['error' => 'ip_not_allowed'], 403);
        }
        return $next($request);
    }
}
