<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class RoleMiddleware
{
    public function handle(Request $request, Closure $next, string $role)
    {
        $user = Auth::user();
        if (!$user || !$user->roles()->where('name', $role)->exists()) {
            abort(403);
        }
        return $next($request);
    }
}

