<?php

namespace App\Http\Controllers;

use App\Models\Wallet;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;

class WalletController extends Controller
{
    public function balance(Request $request)
    {
        $userId = Auth::id() ?? 1;
        $player = Auth::user()->player ?? Auth::user()->player()->create([
            'user_id' => $userId,
            'external_id' => 'USER-' . (string) $userId,
        ]);
        $playerId = $player->id;
        $currency = $request->query('currency', env('GAMES_DEFAULT_CURRENCY', 'BD_BDT'));
        $wallet = Wallet::firstOrCreate(['player_id' => $playerId, 'currency' => $currency]);
        return response()->json(['balance' => (float)$wallet->balance, 'currency' => $currency]);
    }

    public function deposit(Request $request)
    {
        $data = $request->validate(['amount' => 'required|numeric|min:0.01', 'currency' => 'required|string']);
        $userId = Auth::id() ?? 1;
        $player = Auth::user()->player ?? Auth::user()->player()->create([
            'user_id' => $userId,
            'external_id' => 'USER-' . (string) $userId,
        ]);
        $playerId = $player->id;
        DB::transaction(function () use ($playerId, $data) {
            $wallet = Wallet::firstOrCreate(['player_id' => $playerId, 'currency' => $data['currency']]);
            $wallet->balance = $wallet->balance + $data['amount'];
            $wallet->save();
        });
        return response()->json(['status' => 'ok']);
    }

    public function withdraw(Request $request)
    {
        $data = $request->validate(['amount' => 'required|numeric|min:0.01', 'currency' => 'required|string']);
        $userId = Auth::id() ?? 1;
        $player = Auth::user()->player ?? Auth::user()->player()->create([
            'user_id' => $userId,
            'external_id' => 'USER-' . (string) $userId,
        ]);
        $playerId = $player->id;
        DB::transaction(function () use ($playerId, $data) {
            $wallet = Wallet::firstOrCreate(['player_id' => $playerId, 'currency' => $data['currency']]);
            $wallet->balance = $wallet->balance - $data['amount'];
            $wallet->save();
        });
        return response()->json(['status' => 'ok']);
    }
}
